﻿using System;
using System.Linq;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.VideoVisit.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VideoVisit.PipelineSteps.Create
{
    /// <summary>
    /// Gets SA/Appt and Providers
    /// </summary>
    public class GetServiceAppointmentStep : FilterBase<VideoVisitCreateStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(VideoVisitCreateStateObject state)
        {
            using (var srv = new Xrm(state.OrganizationServiceProxy))
            {
                state.CrmAppointment = srv.AppointmentSet.FirstOrDefault(a => a.Id == state.AppointmentId);
                if (state.CrmAppointment != null)
                {
                    if (state.CrmAppointment.cvt_serviceactivityid == null) throw new Exception("Group Appointment has no parent Service Activity");
                    state.ServiceAppointment = srv.ServiceAppointmentSet.FirstOrDefault(sa => sa.Id == state.CrmAppointment.cvt_serviceactivityid.Id);
                }
                else
                {
                    state.ServiceAppointment = srv.ServiceAppointmentSet.FirstOrDefault(x => x.Id == state.AppointmentId);
                }

                // Look up the booked system users in the resources party list and verify they are not from the patient side              
                if (state.ServiceAppointment == null) throw new Exception("Service Appointment cannot be null");
            }
        }
    }
}